/**
* \file: AditMediaBrowser.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: Android Auto
*
* \author: K. Kuroda / ADITJ/SW / kkuroda@jp.adit-jv.com
*
* \copyright (c) 2016 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/
#ifndef AAUTO_ADITMEDIABROWSER_H
#define AAUTO_ADITMEDIABROWSER_H

#include <aauto/MediaBrowserEndpoint.h>
#include <aauto/MessageRouter.h>

namespace adit { namespace aauto {

/**
 * @brief callbacks to receive media browser notifications from MD.
 * All callbacks have empty default implementations.
 * If necessary, need to be implemented . */
class IAditMediaBrowserCallbacks
{
public:
    virtual ~IAditMediaBrowserCallbacks() {}

    /** 
     * Called when a media root node message comes through.
     */
    virtual void rootNodeCallback(const struct MediaRootNodeStruct& node)
    {
        (void) node;
        return;
    }

    /** 
     * Called when a media source node message comes through.
     */
    virtual void sourceNodeCallback(const struct MediaSourceNodeStruct& node)
    {
        (void) node;
        return;
    }

    /** 
     * Called when a media list node message comes through.
     */
    virtual void listNodeCallback(const struct MediaListNodeStruct& node)
    {
        (void) node;
        return;
    }

    /** 
     * Called when a media song node message comes through.
     */
    virtual void songNodeCallback(const struct MediaSongNodeStruct& node)
    {
        (void) node;
        return;
    }

};

/**
 * @brief AditMediaBrowser provides a base class for MediaBrowserSource implementations.
 * It aims to break dependency between ADIT-PF and GalReceiver.
 **/
class AditMediaBrowser : public MediaBrowserEndpoint
{
public:
    AditMediaBrowser(uint8_t inSessionId, MessageRouter* inMessageRouter) :
        MediaBrowserEndpoint(inSessionId, inMessageRouter) {}

    /**
     * @brief Set configuration for platform and AAuto-related items.
     *         All configurations must be called before init().
     * @param  inKey        The key string for configuration
     * @param  inValue      The actual value for configuration */
    virtual void setConfigItem(string inKey, string inValue) = 0;

    /**
     * @brief Register callbacks to receive media playback status notifications.
     * @param   inCallbacks object implementing the callback interface */
    virtual void registerCallbacks(IAditMediaBrowserCallbacks* inCallbacks) = 0;

    /**
     * @brief Initialize the endpoints.
     *      All configuration items must be set before calling this function.
     * @return true if initialization succeeds.
     *      false if fails. */
    virtual bool init() = 0;

    /**
     * @brief  Shut down the endpoint and release allocated resources */
    virtual void shutdown() = 0;
};

} } /* namespace adit { namespace aauto { */

#endif /* AAUTO_ADITMEDIABROWSER_H */

